
/* Step 4: Create the procedure that returns a formatted report. */
Create Procedure up_build_report_output
as
declare @report table(
report_line varchar(30)
)
declare @left_value varchar(10)
declare @middle_value varchar(10)
declare @right_value varchar(10)
declare @as_this_year varchar(4)
declare @as_last_year varchar(4)
declare @as_month_display varchar(12)
declare @ai_month numeric
set @as_this_year = Cast( Year( GetDate() ) as varchar(4) )
set @as_last_year = Cast( ( Year( GetDate() ) - 1 ) as varchar(4) )
set @ai_month = Month( GetDate() )
set @as_month_display = Case @ai_month
 when 1 then 'Jan'
 when 2 then 'Feb'
 when 3 then 'Mar'
 when 4 then 'Apr'
 when 5 then 'May'
 when 6 then 'Jun'
 when 7 then 'Jul'
 when 8 then 'Aug'
 when 9 then 'Sep'
 when 10 then 'Oct'
 when 11 then 'Nov'
 when 12 then 'Dec'
 End
-- Metric 1 Header
set @left_value = [dbo].[uf_center_string]( '<sl>' )
set @middle_value = [dbo].[uf_center_string]( 'Metric 1' )
set @right_value = [dbo].[uf_center_string]( '<sl>' )
--
Insert into @report( report_line )
values( @left_value + @middle_value + @right_value )
--
-- Metric 1 Column Header
set @left_value = [dbo].[uf_center_string]( @as_month_display + ',' + @as_this_year )
set @middle_value = [dbo].[uf_center_string]( '' )
set @right_value = [dbo].[uf_center_string]( @as_month_display + ',' + @as_last_year )
--
Insert into @report( report_line )
values( @left_value + @middle_value + @right_value )
--
-- Metric 1 Values
set @left_value = [dbo].[uf_center_string]( ( select report_in_mil from report_values where report_field = 'metric_one_this_year' ) )
set @middle_value = [dbo].[uf_center_string]('')
set @right_value = [dbo].[uf_center_string]( ( select report_in_mil from report_values where report_field = 'metric_one_last_year' ) )
--
Insert into @report( report_line )
values( @left_value + @middle_value + @right_value )
--
-- Blank Row
set @left_value = [dbo].[uf_center_string]( '<dl>' )
set @middle_value = [dbo].[uf_center_string]( '<dl>' )
set @right_value = [dbo].[uf_center_string]( '<dl>' )
Insert into @report( report_line )
values( @left_value + @middle_value + @right_value )
--

-- ... COPY ABOVE FOR METRIC 2 and METRIC 3 ...

-- Return the formatted email
select report_line from @report

